/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcz;

import java.util.ArrayList;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchRefHost;
import oracle.sysman.oip.oipc.oipch.OipchVendor;
import oracle.sysman.oip.oipc.oipch.OipchVersion;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class OipczOSVendorChecks {
    public static final String SEPARATOR = ",";

    private OipczOSVendorChecks() {
    }

    public static OipcrIResult checkCertifiedOSVendors(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block8: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchVendor oRefVendor;
                    OipchRefHost oRefhost = (OipchRefHost)oRulesEngine.getRefKnowledgeSource("refhost", sRefFile);
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchOS oOS = oHost.getOS();
                    OipchVendor oVendor = oOS.getOSVendor();
                    OipchVersion oVer = oOS.getOSVersion();
                    OipchOS oRefOS = oVer == null ? null : oRefhost.getOSForVersion(oVer);
                    OipchVendor oipchVendor = oRefVendor = oRefOS == null ? null : oRefOS.getOSVendor();
                    if (oRefOS != null) {
                        String sActualVendor = oVendor.getDisplayName();
                        String sExpectedVendor = oRefVendor.getDisplayName();
                        ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                        OipcrIResult oRes = null;
                        int iCompare = oVendor.compare(oRefVendor);
                        oRes = iCompare == 1 ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                        oResDetails.add(new OipcrResultDetails((Object)sActualVendor, (Object)sExpectedVendor, oRes));
                        oResult = new OipcrResult(oResDetails);
                        break block8;
                    }
                    Object[] args = new String[]{oOS == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ004") : oOS.getOSName(), oVer == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ005") : oVer.getDisplayName()};
                    oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18001", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18001", (Object[])args)));
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }
}

